	% Ex 14.27
	close all, clear all, clc
	
	N = 9;             			% Filter order (odd)
	Nd = 6;          		% Number of delay cases
	d = (0:Nd-1)*0.1; 		% Incremental delay cases
	wT = linspace(0, pi, 1000);
	for m = 1: Nd			% Design the Lagrange filters
		D = floor(N/2) + d(m);	% Integer delay + d
		h = ones(1, N+1);
		for n = 0:N      		% Lagrange polynomials    
			for k = 0:N
				if (k ~= n), 
					h(n+1) = h(n+1)*(D-k)/(n-k);
				end
			end
		end	
		hL(m,:) = h/sum(h);		% Scale the response to |H(1)| = 1
		HL(m,:) = freqz(hL(m,:),1,1000)';	% The frequency responses for case m
		uwrapphase = -unwrap(angle(HL(m,:)));
		wT(1) = 1; 				% Avoid to dividing by zero
		phasedelay(m,:) = -uwrapphase./wT; phasedelay(m,1) = phasedelay(m,2);
	end	 
	wT(1) = 0; 
	PLOT_FD_RESPONSE(wT, HL, phasedelay, Nd, d, floor(N/2))		
	
	%=================================================
	%	Farrow Structure
	Np = 3;				% Polynomial order
	for k = 1:N+1		% Fit an Npth-order polynomial to each impulse response value
		h_Farrow(:,k) = flipud(polyfit(d', hL(:,k), Np)');	
	end
	%	h_Farrow are the Farrow impulse reponses for d = 0, 0.1, 0.2,...,0.5
	%	Compute the Farrow impulse response for d = 0.25
	D = floor(N/2);
	d = 0.25;
	h = h_Farrow(1,:);  
	for k = 2:Np+1
		h = h + h_Farrow(k,:)*d^(k-1);
	end    
	H_Farrow = freqz(h/sum(h),1,1000)';	% Scale the response to |H(1)| = 1
	uwrapphase = -unwrap(angle(H_Farrow));
	wT(1) = 1; 				% Avoid to dividing by zero
	phasedelay = -uwrapphase./wT; phasedelay(1) = phasedelay(2);
	PLOT_FD_RESPONSE(wT, H_Farrow, phasedelay, 1, d, floor(N/2))	
	 h_Farrow
